// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import MSSOrchestration

class CDDCMessageViewController: UIViewController {
    @IBOutlet weak var generateButton: UIButton!
    @IBOutlet weak var encryptLabel: UILabel!
    @IBOutlet weak var encrypt: UISwitch!
    @IBOutlet weak var cddcMessage: UILabel!
    
    private let orchestrationDelegate = OrchestrationSampleDelegate()

    private var orchestrator: Orchestrator?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupView()
        setupOrchestration()
    }
    
    // MARK: Setup
    private func setupView() {
        cddcMessage.text = ""
        encryptLabel.text = "cddc_encrypt_label".localized
        generateButton.setTitle("cddc_generate_button".localized, for: .normal)
    }
    
    private func setupOrchestration() {
        orchestrationDelegate.viewController = self
        orchestrator = OrchestratorUtils.getOrchestrator(delegate: orchestrationDelegate,
                                                         collectCDDC: false)
    }
    
    // MARK: IBAction
    
    @IBAction func onGenerateMessageClick(_ sender: Any) {
        // Get Current Orchestration User
        guard let activatedUser = SharedPreferenceStorage.getActivatedUser() else {
            assertionFailure("can't retrieve activated user")
            return
        }
        let user = OrchestrationUser(identifier: activatedUser, domain: nil)
        
        // Retrive encrypt information
        let encrypted: Bool = encrypt.isOn
        
        // Event Name
        // This code value is predefined, and need to be indicated by server side
        // Avalaible codes are visible in the CDDC Technical Documentation
        let eventName = "eventnamecode"
        
        // Application Data
        // This is an extra information ask by server side, the final content need to be indicated by them.
        // The expected formatting is a JSON in string format
        let applicationData = "{}"
        
        // Create message parameters
        let params = CDDCMessageParameters(user: user, eventName: eventName, applicationData: applicationData, isEncrypted: encrypted)
        
        // Generate the message
        do {
            let message = try orchestrator?.cddcMessage(with: params)
            cddcMessage.text = message
        } catch let error as OrchestrationError {
            print("OrchestrationError - code: \(error.errorCode), cause: \(String(describing: error.failureReason))")
        } catch {
            assertionFailure("The error thrown should be of type OrchestrationError!")
        }
    }
}
